//Program for Economic Load Dispatch problem including loss coefficients//
//This program requires user input. A sample problem with user input and output is available in the result file named "EDwithLoss.jpg"//
//Scilab Version 5.5.2 ; OS:Windows
clear;
clc;
n=input('Enter no. of units :');
B=input('Enter the loss coefficient in matrix form :');
a=B(:,1);//loss coefficients stored in variable a
b=B(:,2);//loss coefficients stored in variable b
c=B(:,3);//loss coefficients stored in variable c
pg=input('Enter the power of the units in matrix form in p.u:');
bv=input('Enter the base value');
pl=0;
for i=1:n//calculation of power loss
    for j=1:n
        pl=pl+pg(j)*B(i,j)*pg(i);
    end
end
disp(pl,'The transmission power loss in pu is',);
ITL=zeros(n,1);//Calculation of incremental transmission loss
for i=1:n
    for j=1:n
        ITL(i)=ITL(i)+2*B(i,j)*pg(j);
        
        end
end
disp(ITL,'The incremental losses in pu are');

//SAMPLE INPUT:

//Enter no. of units :3
//Enter the loss coefficient in matrix form :[0.01 -0.0003 -0.0002;-0.0003 0.0025 -0.0005;-0.0002 -0.0005 0.0031]
//Enter the power of the units in matrix form in p.u:[50/200 100/200 200/200]
//Enter the base value200
 
 //OUTPUT
 //The transmission power loss in pu is   
 
//    0.003675  
 
// The incremental losses in pu are   
 
//    0.0043   
//    0.00135  
//    0.0056
